﻿#pragma once

namespace RTCam {

class Texture;

class Aperture
{
public:
	Aperture(void);
	~Aperture(void);

	// The current f-number
	float GetFNumber();
	void SetFNumber(float fNumber);
	float ValidateFNumber(float fNumber);

	void SetFNumberRange(float minFNumber, float maxFNumber);

	// Bokeh texture
	shared_ptr<Texture> m_bokehTex;

private:
	float m_minFNumber;		// The smallest f-number of the lens (max aperture)
	float m_maxFNumber;		// The largest f-number of the lens (min aperture)
	float m_curFNumber;		// The current f-number
};

} // end namespace